
/**
 ******************************************************************************
 *
 * @file        RingBuffer2.h
 * @brief       Ring Buffer headfile.
 *
 * @par         Project
 *              MG32x02z
 * @version     V1.01
 * @date        2021/05/31
 * @author      Megawin Software Center
 * @copyright   Copyright (c) 2017 MegaWin Technology Co., Ltd.
 *              All rights reserved.
 *
 ******************************************************************************* 
 * @par Disclaimer
 * The Demo software is provided "AS IS" without any warranty, either
 * expressed or implied, including, but not limited to, the implied warranties
 * of merchantability and fitness for a particular purpose. The author will
 * not be liable for any special, incidental, consequential or indirect
 * damages due to loss of data or any other reason.
 * These statements agree with the world wide and local dictated laws about
 * authorship and violence against these laws.
 *******************************************************************************
 *******************************************************************************
 */


#include <stdint.h>
#include <stdbool.h>
#ifndef RING_BUFFER_H__
#define RING_BUFFER_H__

/* Includes ------------------------------------------------------------------*/
#include <stdint.h>

/* Wizard menu ---------------------------------------------------------------*/
/* Private typedef -----------------------------------------------------------*/
#define RING_BUFFER_LENGTH 1000

typedef struct {
    uint8_t buf[RING_BUFFER_LENGTH];
#if RING_BUFFER_LENGTH < 255
    uint8_t head, tail;
#else
    uint16_t head, tail;
#endif
} RingBuffer;

typedef enum {
    RING_BUFFER_OK = 0x0,
    RING_BUFFER_FULL,
    RING_BUFFER_NO_SUFFICIENT_SPACE
} RingBuffer_Status;

/* Private define ------------------------------------------------------------*/
/* Private macro -------------------------------------------------------------*/
/* Private variables ---------------------------------------------------------*/
/* Private function prototypes -----------------------------------------------*/
void RingBuffer_Init(RingBuffer *pBuffer);
uint16_t RingBuffer_Read(RingBuffer *pBuffer, uint8_t *pData, uint16_t Length);
uint8_t RingBuffer_Write(RingBuffer *pBuffer, uint8_t *pData, uint16_t Length);
uint16_t RingBuffer_GetDataLength(RingBuffer *pBuffer);
uint16_t RingBuffer_GetFreeSpace(RingBuffer *pBuffer);

/* Exported variables --------------------------------------------------------*/
/* Exported functions --------------------------------------------------------*/
/* External vairables --------------------------------------------------------*/


#endif //#ifndef RING_BUFFER_H__

